﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultPerformancePlugin.Controls.Strategy
{
    public interface IPortThreadPriorityStrategy
    {
        void Write(int num);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class  PortThreadPriorityDefaultStrategy : ICorrespondenceOS, IPortThreadPriorityStrategy
    {
        public  PortThreadPriorityDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           
#if DEBUG
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "SchedulerThreadPriority";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion


        public void Write(int num)
        {
            RegistryKey registryKey =
                Registry.LocalMachine.CreateSubKey(
                    @"SYSTEM\CurrentControlSet\Control\Print");

            registryKey.SetValue(RegName,num,RegistryValueKind.DWord);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.LocalMachine.OpenSubKey(
                    @"SYSTEM\CurrentControlSet\Control\Print");

            return new WFRegistry(@"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Print", RegName,
                                  registryKey.GetValue(RegName, 0), RegistryValueKind.DWord, RegOperation.ValueWrite);
        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

    }

    public class  PortThreadPriorityController
    {
        public PortThreadPriorityController( PortThreadPriority schePortThreadPriority,
                                                         IPortThreadPriorityStrategy strategy)
        {
            PortThreadPriority = schePortThreadPriority;
            Strategy = strategy;
        }

        public  PortThreadPriority PortThreadPriority { get; set; }
        public  IPortThreadPriorityStrategy Strategy { get; set; }

        public void Read()
        {
            PortThreadPriority.SetPortThreadPriorityValue(Convert.ToInt32(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(PortThreadPriority.GetPortThreadPriorityValue());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
